
using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Presenter;
using System;
using System.Collections.Generic;
using System.IO;
using inetsoftware.Pdfc.Config;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A simple sample for exporting the results with specific visiblity and color setting
    /// Expects 2 arguments - the paths of the PDF files to be compared
    /// </summary>
    public class UseSettings
    {
        static UseSettings()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show how exporting the result of a comparison of 2 PDF Files to a PDF,
        /// showing how to set the export path for this comparison report.
        /// </summary>
        /// <param name="args">Expects 2 arguments: the paths of the 2 PDF files that will be compared.</param>
        public static void Main(string[] args) {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            IDictionary<string, string> settings = new Dictionary<string, string>();
            //change the default color for add/remove differences in green.
            //The color format can be defined using 6 or 8 characters (0-9 and a-f).
            settings[PDFCVisibility.ADDEDORREMOVED_COLOR] = "00FF0020";
            //Show no modified differences
            settings[PDFCVisibility.MODIFIED_VISIBILITY] = "hidden";
            //Show the header recognition
            settings[PDFCVisibility.HEADERFOOTER_VISIBILITY] = "visible";


            //Used the current i-net PDFC profile. If no profile has been previously set then the default profile will be used.
            DifferencesPDFPresenter differencesPDFPresenter = new DifferencesPDFPresenter(Path.GetDirectoryName(args[0]));
            using (new PDFComparer()
                            .SetSettings(settings)
                            .AddPresenter(differencesPDFPresenter)
                            .Compare(args[0], args[1]))
            { }
        }
    }
}
